% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{hmm_simulate_normal_data}
\alias{hmm_simulate_normal_data}
\title{Simulate data distributed according to oHMMed with normal emission densities}
\usage{
hmm_simulate_normal_data(L, mat_T, means, sigma)
}
\arguments{
\item{L}{(integer) number of simulations}

\item{mat_T}{(matrix) a square matrix with the initial state}

\item{means}{(numeric) \code{mean} parameter in \code{\link{rnorm}} for emission probabilities}

\item{sigma}{(numeric) \code{sd} parameter in \code{\link{rnorm}} for emission probabilities}
}
\value{
Returns a list with the following elements:
\itemize{
  \item \code{data}: numeric vector with data
  \item \code{states}: an integer vector with "true" hidden states used to generate the data vector
  \item \code{pi}: numeric vector with prior probability of states
}
}
\description{
Simulate data distributed according to oHMMed with normal emission densities
}
\examples{
mat_T0 <- rbind(c(1-0.01, 0.01, 0),
                c(0.01, 1-0.02, 0.01),
                c(0, 0.01, 1-0.01))
L <- 2^7
means0 <- c(-1,0,1)
sigma0 <- 1

sim_data <- hmm_simulate_normal_data(L = L, 
                                     mat_T = mat_T0, 
                                     means = means0, 
                                     sigma = sigma0)
                                     
plot(density(sim_data$data), main = "Density of Simulated Normal Data")
sim_data
}
