% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id.R
\name{id}
\alias{id}
\title{Identify the OAI-PMH service for each data provider.}
\usage{
id(url, ...)
}
\arguments{
\item{url}{(character) OAI-PMH base url}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Identify the OAI-PMH service for each data provider.
}
\examples{
\dontrun{
# datacite
id("http://oai.datacite.org/oai")

# arxiv
id("http://export.arxiv.org/oai2")

# GBIF - http://www.gbif.org/
id("http://api.gbif.org/v1/oai-pmh/registry")

# curl options
library("httr")
id("http://export.arxiv.org/oai2", config = verbose())
}
}

