% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.chain.R
\name{is.chain}
\alias{is.chain}
\alias{is.chain.rtree}
\title{Test if a tree is a chain}
\usage{
is.chain(x)

\method{is.chain}{rtree}(x)
}
\arguments{
\item{x}{A tree to be tested.}
}
\value{
A logical.
}
\description{
The function \code{is.chain} returns \code{TRUE} 
if \code{x} is a chain, \code{FALSE} otherwise.
}
\examples{
## FALSE
is.chain(empty_tree())

## TRUE
(tr0 = c_("Bob", "Carl", "Daniel"))
is.chain(tr0)

## FALSE
(tr1 = r_(s = list(tr0)))
is.chain(tr1)

## FALSE
(tr = r_("titi", s = list(r_("toto"), r_("tata"))))
is.chain(tr)

}
