context("Test 'siblings()' function")

test_that("function 'siblings()' works properly", {
  
  expect_identical(list(), siblings("TOTO", empty_tree()))
  
  tr0 = c_("Bob", "Carl", "Daniel")
  expect_identical(list(), siblings("Bob", tr0))
  expect_identical(list(), siblings("Carl", tr0))
  expect_identical(list(), siblings("Daniel", tr0))
  expect_identical(list(), siblings("TOTO", tr0))
  
  tr1 = r_("Dimitri", s = list(c_("Enoc"), c_("Ferdinand")))
  expect_identical(list(), siblings("Dimitri", tr1))
  expect_identical(list(r_("Ferdinand")), siblings("Enoc", tr1))
  expect_identical(list(r_("Enoc")), siblings("Ferdinand", tr1))
  expect_identical(list(), siblings("TOTO", tr1))
  
  tr1 = r_("Caroline", s = list(tr1))
  expect_identical(list(), siblings("Caroline", tr1))
  expect_identical(list(), siblings("Dimitri", tr1))
  expect_identical(list(r_("Ferdinand")), siblings("Enoc", tr1))
  expect_identical(list(r_("Enoc")), siblings("Ferdinand", tr1))
  expect_identical(list(), siblings("TOTO", tr1))
  
  tr1 = r_("Bill", s = list(tr1))
  expect_identical(list(), siblings("Bill", tr1))
  expect_identical(list(), siblings("Caroline", tr1))
  expect_identical(list(), siblings("Dimitri", tr1))
  expect_identical(list(r_("Ferdinand")), siblings("Enoc", tr1))
  expect_identical(list(r_("Enoc")), siblings("Ferdinand", tr1))
  expect_identical(list(), siblings("TOTO", tr1))
  
  tr2 = r_("Alice", s = list(tr0, tr1))
  expect_identical(list(), siblings("Alice", tr2))
  expect_identical(list(r_("Bob")), siblings("Bill", tr2))
  expect_identical(list(r_("Bill")), siblings("Bob", tr2))
  expect_identical(list(), siblings("Carl", tr2))
  expect_identical(list(), siblings("Daniel", tr2))
  expect_identical(list(), siblings("Caroline", tr2))
  expect_identical(list(), siblings("Dimitri", tr2))
  expect_identical(list(r_("Ferdinand")), siblings("Enoc", tr2))
  expect_identical(list(r_("Enoc")), siblings("Ferdinand", tr2))
  expect_identical(list(), siblings("TOTO", tr2))
  
  ## Unrooted tree
  tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son")))
  expect_identical(list(), siblings("Alice", tr3))
  expect_identical(list(), siblings("Grand-Mother", tr3))
  expect_identical(list(r_("Bob")), siblings("Bill", tr3))
  expect_identical(list(r_("Bill")), siblings("Bob", tr3))
  expect_identical(list(), siblings("Carl", tr3))
  expect_identical(list(), siblings("Daniel", tr3))
  expect_identical(list(), siblings("Caroline", tr3))
  expect_identical(list(), siblings("Dimitri", tr3))
  expect_identical(list(r_("Ferdinand")), siblings("Enoc", tr3))
  expect_identical(list(r_("Enoc")), siblings("Ferdinand", tr3))
  expect_identical(list(), siblings("Father", tr3))
  expect_identical(list(), siblings("Son", tr3))
  expect_identical(list(), siblings("TOTO", tr3))
  
})
