% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oasis_erode.R
\name{oasis_erode}
\alias{oasis_erode}
\title{OASIS Erode Mask}
\usage{
oasis_erode(mask, mm = c(5, 5, 5))
}
\arguments{
\item{mask}{object of class \code{\link{nifti}}}

\item{mm}{Number of erosion (in millimeters)}
}
\value{
Object of class \code{\link{nifti}}
}
\description{
An alternative to using \code{fslerode} for mask erosion of a 
brain mask by a box kernel defined by millimeter
}
\examples{
library(neurobase)
library(fslr)
library(oasis)
niis = tempfile(fileext = ".nii.gz")
if (require(httr)) {
   url = paste0("https://s3.us-east-2.amazonaws.com/brainder/software/",
   "flair/templates/GG-853-FLAIR-2.0mm.nii.gz")
   req <- httr::GET(url,
   httr::write_disk(path = niis))
   httr::stop_for_status(req)

 flair <- fast_readnii(niis)
 res = oasis_erode(flair > 50, mm = c(2, 2, 2))
}
}
