% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotTimeSeries}
\alias{plotTimeSeries}
\title{General purpose time series plot.}
\usage{
plotTimeSeries(timestamp, series, start.time = min(timestamp),
  end.time = max(timestamp), title = "time series", y.label = "series")
}
\arguments{
\item{timestamp}{POSIXct timestamps.}

\item{series}{The time series.}

\item{start.time}{Plot from this time onward.}

\item{end.time}{Plot up until this time.}

\item{title}{Plot title.}

\item{y.label}{Y axis label of the plot.}
}
\description{
Convenience function for plotting time series.
}
\examples{

# plot trades.
with(lob.data$trades, plotTimeSeries(timestamp, price))

# plot a general time series.
timestamp <- seq(as.POSIXct("2015-05-01 00:00:00.000", tz="UTC"), 
                 as.POSIXct("2015-05-01 00:59:00.000", tz="UTC"), by=60)
series <- rep(1:10, 6)
plotTimeSeries(timestamp, series)

}
\author{
phil
}

