% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{ctdAddColumn}
\alias{ctdAddColumn}
\title{Add a column to the data slot of a ctd object}
\usage{
ctdAddColumn(x, column, name, label, unit = NULL,
  debug = getOption("oceDebug"))
}
\arguments{
\item{x}{A \code{ctd} object, e.g. as read by \code{\link{read.ctd}}.}

\item{column}{A column of data to be inserted, in the form of a
numeric vector, whose length matches that of columns in the
objecct.}

\item{name}{Character string indicating the name this column is to
have in the \code{data} slot of \code{x}.}

\item{label}{Optional character string or expression indicating the
name of the column, as it will appear in plot labels.  (If not
given, \code{name} will be used.)}

\item{unit}{Optional indication of the unit, in the form of a list containing
items \code{unit}, which is an expression, and \code{scale}, which is a
character string. For example, modern measurements of temperature have
unit \code{list(name=expression(degree*C), scale="ITS-90")}.}

\item{debug}{A debugging flag; set this to a positive value to get debugging
information during processing.}
}
\value{
A ctd object.
}
\description{
Add a column to the \code{data} slot of an object of
\code{\link{ctd-class}}, also updating the \code{metadata}
slot as appropriate.
}
\examples{
library(oce)
data(ctd) 
F <- 32 + (9/5)*ctd[["temperature"]] 
ctdNew <- ctdAddColumn(ctd, F, "temperatureF", 
    unit=list(unit=expression(degree*F), scale="ITS-90"))
}
\seealso{
The documentation for \code{\link{ctd-class}} explains the structure
   of CTD objects, and also outlines the other functions dealing with them.
}

