% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{drawDirectionField}
\alias{drawDirectionField}
\title{Draw a Direction Field}
\usage{
drawDirectionField(x, y, u, v, scalex, scaley, length = 0.05, add = FALSE,
  type = 1, col = par("fg"), pch = 1, cex = par("cex"),
  lwd = par("lwd"), lty = par("lty"), debug = getOption("oceDebug"))
}
\arguments{
\item{x, y}{coordinates at which velocities are specified.}

\item{u, v}{velocity components in the x and y directions.}

\item{scalex, scaley}{scale to be used for the velocity arrows.  Exactly one
of these must be specified.  Arrows that have \code{u^2+v^2=1} will
have length \code{scalex} along the x axis, or \code{scaley} along the
y axis, according to which argument is given.}

\item{length}{indication of \strong{width} of arrowheads. The somewhat
confusing name of this argument is a consequence of the fact
that it is passed to \code{\link{arrows}} for drawing arrows.
Note that the present default is smaller than the default used
by \code{\link{arrows}}.}

\item{add}{if \code{TRUE}, the arrows are added to an existing plot;
otherwise, a new plot is started by calling \code{\link{plot}} with
\code{x}, \code{y} and \code{type="n"}.  In other words, the plot
will be very basic. In most cases, the user will probably want to
draw a diagram first, and \code{add} the direction field later.}

\item{type}{indication of the style of arrow-like indication of the direction.}

\item{col}{colour of line segments or arrows}

\item{pch, cex}{plot character and expansion factor, used for \code{type=1}}

\item{lwd, lty}{line width and type, used for \code{type=2}}

\item{debug}{debugging value; set to a positive integer to get debugging
information.}
}
\value{
None.
}
\description{
The direction field is indicated variously, depending on the value of
\code{type}:\itemize{  
\item For \code{type=1}, each indicator is drawn with a symbol, according to the
value of \code{pch} (either supplied globally, or as an element of the
\code{...} list) and of size \code{cex}, and colour \code{col}.   Then, a
line segment is drawn for each, and for this \code{lwd} and \code{col} may
be set globally or in the \code{...} list.
\item For \code{type=2}, the points are not drawn, but arrows are drawn instead
of the line segments.  Again, \code{lwd} and \code{col} control the type of
the line.
}
}
\examples{
library(oce)
plot(c(-1.5, 1.5), c(-1.5, 1.5), xlab="", ylab="", type='n')
drawDirectionField(x=rep(0, 2), y=rep(0, 2), u=c(1,1), v=c(1, -1), scalex=0.5, add=TRUE)
plot(c(-1.5, 1.5), c(-1.5, 1.5), xlab="", ylab="", type='n')
drawDirectionField(x=rep(0, 2), y=rep(0, 2), u=c(1,1), v=c(1, -1), scalex=0.5, add=TRUE,
                   type=2)
}
\author{
Dan Kelley
}

