% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\docType{methods}
\name{plot,met-method}
\alias{plot,met-method}
\title{Plot Met Data}
\usage{
\S4method{plot}{met}(x, which = 1:4, mgp = getOption("oceMgp"),
  mar = c(mgp[1] + 1, mgp[1] + 1, mgp[1] + 1, mgp[1] + 1), tformat,
  debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{A \code{met} object, e.g. as read by \code{\link{read.met}}, or a
list containing items named \code{salinity} and \code{temperature}.}

\item{which}{list of desired plot types.  \itemize{ \item \code{which=1}
gives a time-series plot of temperature \item \code{which=2} gives a
time-series plot of pressure \item \code{which=3} gives a time-series plot
of the x (eastward) component of velocity \item \code{which=4} gives a
time-series plot of the y (northward) component of velocity }}

\item{mgp}{A three-element numerical vector to use for \code{par(mgp)}
to control spacing of axis elements.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{A four-element numerical vector to be used with \code{\link{par}("mar")}.}

\item{tformat}{optional argument passed to \code{\link{oce.plot.ts}}, for
plot types that call that function.  (See \code{\link{strptime}} for the
format used.)}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}

\item{\dots}{optional arguments passed to plotting functions.}
}
\description{
Creates a multi-panel summary plot of data measured in a meteorological data
set.  cast. The panels are controlled by the \code{which} argument.
Normally, 4 panels are specified with the \code{which}, but it can also be
useful to specify less than 4 panels, and then to draw other panels after
this call.
}
\details{
If more than one panel is drawn, then on exit from \code{plot.met}, the
value of \code{par} will be reset to the value it had before the function
call.  However, if only one panel is drawn, the adjustments to \code{par}
made within \code{plot.met} are left in place, so that further additions may
be made to the plot.
}
\examples{
library(oce)
data(met)
plot(met, which=3:4)

}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{met} data: \code{\link{[[,met-method}},
  \code{\link{[[<-,met-method}}, \code{\link{as.met}},
  \code{\link{met-class}}, \code{\link{met}},
  \code{\link{read.met}}, \code{\link{subset,met-method}},
  \code{\link{summary,met-method}}
}

