% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\docType{class}
\name{sealevel-class}
\alias{sealevel-class}
\title{Class to Store Sealevel Data}
\description{
Class to store sealevel data, e.g. from a tide gauge, with standard slots
\code{metadata}, \code{data} and \code{processingLog}.
}
\section{Methods}{
 Data may be accessed as e.g.  \code{sealevel[["time"]]},
where the string could also be e.g.  \code{"elevation"} for the
corresponding sea-level elevation, or e.g.  \code{"longitude"} or
\code{"latitude"} for scalars.  Items in \code{metadata} must be specifield
by full name, but those in \code{data} may be abbreviated, so long as the
abbreviation is unique.

Everything that may be accessed may also be assigned, e.g.
\code{sealevel[["elevation"]] <- value}.

The \code{show} method displays information about the object, while
\code{\link{summary,sealevel-method}} provides a statistical summary.
}
\author{
Dan Kelley
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{sealevel} data: \code{\link{[[,sealevel-method}},
  \code{\link{[[<-,sealevel-method}},
  \code{\link{as.sealevel}},
  \code{\link{plot,sealevel-method}},
  \code{\link{read.sealevel}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}},
  \code{\link{subset,sealevel-method}},
  \code{\link{summary,sealevel-method}}
}

