% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\docType{methods}
\name{[[,section-method}
\alias{[[,section-method}
\title{Extract Something From a Section Object}
\usage{
\S4method{[[}{section}(x, i, j, ...)
}
\arguments{
\item{x}{A \code{section} object, i.e. one inheriting from \code{\link{section-class}}.}

\item{i}{Character string indicating the name of item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \code{\link{oce-class}}.  The purpose,
as with the related replacement method, \code{\link{[[<-}}, 
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items not actually stored can also be 
extracted, including derived data, units of measurement,
and data-quality flags.

The method uses a two-step process to try to find the
requested information. First, a class-specific function 
is used to try to access the requested information (see
\dQuote{Details of the specialized ... method}). 
Second, if no match is found, a general function is used
(see \sQuote{Details of the general method}). If neither
method can locates the requested item, \code{NULL} is returned.
}
\section{Details of the specialized section method}{

If \code{i} is the string \code{"station"}, then the method
will return a \code{\link{list}} of
\code{\link{ctd-class}} objects holding the station data. If \code{j}
is also given and is an integer, then just the j-th station in the section is returned.

If \code{i} is \code{"station ID"}, then the IDs of the stations in the
section are returned.

If \code{i} is \code{"dynamic height"}, then an estimate of dynamic
height is returned (as calculated with \code{\link{swDynamicHeight}(x)}).

If \code{i} is \code{"distance"}, then the distance along the section is
returned, using \code{\link{geodDist}}.

If \code{i} is \code{"depth"}, then a vector containing the depths
of the stations is returned.

If \code{i} is \code{"theta"} or \code{"potential temperature"}, then
the potential temperatures of all the stations are returned in one
vector.  Similarly, \code{"spice"} returns the property known
as spice, using \code{\link{swSpice}}.

If \code{i} is a string ending with \code{"Flag"}, then the characters
prior to that ending are taken to be the name of a variable contained
within the stations in the section. If this flag is available in
the first station of the section, then the flag values are looked
up for every station.


If none of the conditions listed above holds, the general
method is used (see \sQuote{Details of the general method}).
}

\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the value of \code{i}.

First, a check is made as to whether \code{i} names one of the standard
\code{oce} slots, and returns the slot contents if so. Thus, 
\code{x[["metadata"]]} will retrieve the \code{metadata} slot, 
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.

Next, if \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link{expression}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]}, then just the expression is returned, 
and if it ends in \code{" scale"}, then just the scale is returned.

Next, if \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag). 
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.

If none of the preceding conditions are met, a check is done
to see if the \code{metadata} slot contains an item with
the provided name, and that is returned, if so. A direct match
is required for this condition.

Finally, the \code{data} slot is checked to see if it contains 
an item with the name indicated by \code{i}. In this case, a partial
match will work; this is accomplished by using \code{\link{pmatch}}.

If none of the above-listed conditions holds, then \code{NULL} is returned.
}

\examples{
data(section)
length(section[["latitude"]])
length(section[["latitude", "byStation"]])

data(section)
length(section[["latitude"]])
length(section[["latitude", "byStation"]])

}
\seealso{
Other things related to \code{section} data: \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}

Other functions that extract parts of \code{oce} objects: \code{\link{[[,adp-method}},
  \code{\link{[[,adv-method}},
  \code{\link{[[,amsr-method}},
  \code{\link{[[,argo-method}},
  \code{\link{[[,bremen-method}},
  \code{\link{[[,cm-method}},
  \code{\link{[[,coastline-method}},
  \code{\link{[[,ctd-method}},
  \code{\link{[[,echosounder-method}},
  \code{\link{[[,g1sst-method}},
  \code{\link{[[,gps-method}},
  \code{\link{[[,ladp-method}},
  \code{\link{[[,lisst-method}},
  \code{\link{[[,lobo-method}},
  \code{\link{[[,met-method}}, \code{\link{[[,odf-method}},
  \code{\link{[[,rsk-method}},
  \code{\link{[[,sealevel-method}},
  \code{\link{[[,tidem-method}},
  \code{\link{[[,topo-method}},
  \code{\link{[[,windrose-method}},
  \code{\link{[[<-,adv-method}}
}
\author{
Dan Kelley
}
