% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{matchBytes}
\alias{matchBytes}
\title{Locate byte sequences in a raw vector}
\usage{
matchBytes(input, b1, ...)
}
\arguments{
\item{input}{a vector of raw (byte) values.}

\item{b1}{a vector of bytes to match (must be of length 2 or 3 at present;
for 1-byte, use \code{\link{which}}).}

\item{\dots}{additional bytes to match for (up to 2 permitted)}
}
\value{
List of the indices of \code{input} that match the start of the
\code{bytes} sequence (see example).
}
\description{
Find spots in a raw vector that match a given byte sequence.
}
\examples{

buf <- as.raw(c(0xa5, 0x11, 0xaa, 0xa5, 0x11, 0x00))
match <- matchBytes(buf, 0xa5, 0x11)
print(buf)
print(match)
}
\author{
Dan Kelley
}
