% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{prettyPosition}
\alias{prettyPosition}
\title{Pretty lat/lon in deg, min, sec}
\usage{
prettyPosition(x, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{a series of one or more values of a latitude or longitude, in
decimal degrees}

\item{debug}{set to a positive value to get debugging information during
processing.}
}
\value{
A vector of numbers that will yield good axis labels if
\code{\link[=formatPosition]{formatPosition()}} is used.
}
\description{
Round a geographical positions in degrees, minutes, and seconds
Depending on the range of values in \code{x}, rounding is done to degrees,
half-degrees, minutes, etc.
}
\examples{
library(oce)
formatPosition(prettyPosition(10+1:10/60+2.8/3600))
}
\author{
Dan Kelley
}
