% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceSmooth}
\alias{oceSmooth}
\alias{oce.smooth}
\title{Smooth an oce Object}
\usage{
oceSmooth(x, ...)
}
\arguments{
\item{x}{an \linkS4class{oce} object.}

\item{\dots}{parameters to be supplied to \code{\link[=smooth]{smooth()}}, which does
the actual work.}
}
\value{
An \linkS4class{oce} object that has been smoothed appropriately.
}
\description{
Each data element is smoothed as a timeseries. For ADP data, this is done
along time, not distance.  Time vectors, if any, are not smoothed.  A good
use of \code{oce.smooth} is for despiking noisy data.
}
\examples{
library(oce)
data(ctd)
d <- oce.smooth(ctd)
plot(d)
}
\seealso{
The work is done with \code{\link[=smooth]{smooth()}}, and the \code{...}
arguments are handed to it directly by \code{oce.smooth}.
}
\author{
Dan Kelley
}
