% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceNPMLE.R
\name{oceNPMLE}
\alias{oceNPMLE}
\title{Estimate win ratio or Mann-Whitney parameter using NPMLE}
\usage{
oceNPMLE(oceData)
}
\arguments{
\item{oceData}{output from \code{\link{oceFormat}}}
}
\value{
An object of class 'oceNPMLE', which is a list with the following
elements (where Yg=ordered composite endpoint score for group=g):
\describe{
 \item{oceNames}{long names for each of the ordered endpoints}
 \item{TAU}{maximum of all the time-to-event variables (even censored ones)}
 \item{KM0}{survfit output for group=0 subset}
 \item{KM1}{survfit output for group=1 subset}
 \item{WR}{win ratio, estimate of P[Y1>Y0]/P[Y0>Y1]}
 \item{MW}{desirability of outcome ranking, estimate of P[Y1>Y0]+(1/2)P[Y1=Y0]}
 }
}
\description{
Estimation done using NPMLE (nonparametric maximum likelihood estimators of
survival).
}
\seealso{
See \code{\link{plot.oceNPMLE}} for an example with plotting.
}
