% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drag.R
\docType{data}
\name{drag}
\alias{drag}
\title{Wind drag coefficient}
\usage{
data(drag, package="ocedata")
}
\description{
\code{drag} holds wind drag coefficients for wind-profile and eddy-covariance
methods, summarized in Figure 3 of Garratt (1977).  The data are stored in a
data frame with four columns: \code{U} is wind speed in m/s; \code{Cd} is for
(neutral) drag coefficient; \code{n} is the number of data measurements
represented by the value; and \code{method} is a factor with two levels:
\code{profile} and \code{eddy}, for two methods of inferring \code{Cd}.
}
\details{
The data were digitized from Figure 3 of Garratt (1977) by Dan Kelley.
}
\examples{
data(drag, package="ocedata")
par(mar=c(3,3,1,1), mgp=c(2, 0.7, 0))
plot(drag$U, drag$Cd, pch=ifelse(drag$method == "profile", 1, 19),
    xlab="U [m/s]", ylab=expression(C[D]),
    xlim=c(0, 22), ylim=c(0, 3e-3))
legend("topleft", pch=c(1,19),
    legend=c("profile method", "eddy covariance method"))


}
\references{
J. R. Garratt, 1977.  Review of drag coefficients over oceans and
continents. \emph{Monthly Weather Review}, 105:915-927.
}
