% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_images.R
\name{compare_images_batch}
\alias{compare_images_batch}
\title{Compare Multiple Image Pairs}
\usage{
compare_images_batch(pairs, diff_dir = NULL, ...)
}
\arguments{
\item{pairs}{A data.frame with columns \code{img1} and \code{img2} containing
file paths, or a list of named lists with \code{img1} and \code{img2} elements.}

\item{diff_dir}{Directory to save diff images. If \code{NULL}, no diff images
are created. If provided, diff images are named based on the input
file names.}

\item{...}{Additional arguments passed to \code{\link[=compare_images]{compare_images()}}.}
}
\value{
A tibble (if available) or data.frame with one row per comparison,
containing all columns from \code{\link[=compare_images]{compare_images()}} plus a \code{pair_id} column.
}
\description{
Compare multiple pairs of images in batch. Useful for visual regression
testing across many screenshots.
}
\examples{
\dontrun{
# Create a data frame of image pairs
pairs <- data.frame(
  img1 = c("baseline/page1.png", "baseline/page2.png"),
  img2 = c("current/page1.png", "current/page2.png")
)

# Compare all pairs
results <- compare_images_batch(pairs, diff_dir = "diffs/")

# Check which comparisons failed
results[!results$match, ]
}
}
