% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.3.R
\name{power.3}
\alias{power.3}
\title{Required budget (and/or sample size), power, MDES calculation for three-level CRTs}
\usage{
power.3(cost.model = TRUE, expr = NULL, constraint = NULL,
  sig.level = 0.05, two.tailed = TRUE, es = NULL, power = NULL,
  m = NULL, n = NULL, J = NULL, K = NULL, p = NULL, icc2 = NULL,
  icc3 = NULL, r12 = NULL, r22 = NULL, r32 = NULL, q = NULL,
  c1 = NULL, c2 = NULL, c3 = NULL, c1t = NULL, c2t = NULL,
  c3t = NULL, eslim = NULL, powerlim = NULL, Klim = NULL, mlim = NULL,
  rounded = TRUE)
}
\arguments{
\item{cost.model}{logical, perform power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, perform conventional power analyses
(e.g., required sample size, power, or MDES calculation) if FALSE; default is TRUE.}

\item{expr}{returned objects from function \code{\link{od.3}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc2}, \code{icc3},
\code{r12}, \code{r22}, \code{r32},
\code{c1}, \code{c2}, \code{c3}, \code{c1t}, \code{c2t}, \code{c3t},
\code{p}, \code{n}, and \code{J}
used or solved in function \code{\link{od.3}} will
be passed to the current function;
only the values of \code{p}, \code{n}, and/or \code{J} that specified or solved in
function \code{\link{od.3}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{specify the constrained values of \code{p}, \code{n},
and/or \code{J} in list format to overwrite those
from \code{expr}; default is NULL.}

\item{sig.level}{significance level or type I error rate, default is 0.05.}

\item{two.tailed}{logical; perform two-tailed tests if TRUE,
perform one-tailed tests if FALSE; default is TRUE.}

\item{es}{effect size.}

\item{power}{statistical power.}

\item{m}{total budget.}

\item{n}{the average level-1 sample size per level-2 unit.}

\item{J}{the average level-2 sample size per level-3 unit.}

\item{K}{the level-3 sample size across treatment conditions.}

\item{p}{the proportion of level-3 clusters/units assigned to treatment.}

\item{icc2}{the unconditional intraclass correlation coefficient (icc) at level 2.}

\item{icc3}{the unconditional intraclass correlation coefficient (icc) at level 3.}

\item{r12}{the proportion of level-1 variance explained by covariates.}

\item{r22}{the proportion of level-2 variance explained by covariates.}

\item{r32}{the proportion of level-3 variance explained by covariates.}

\item{q}{the number of covariates at level 3.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit in control condition.}

\item{c3}{the cost of sampling one level-3 unit in control condition.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{the cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{the cost of sampling one level-3 unit in treatment condition.}

\item{eslim}{the range for searching the root of effect size (\code{es}) numerically,
default is c(0, 5).}

\item{powerlim}{the range for searching the root of power (\code{power}) numerically,
default is c(1e-10, 1 - 1e-10).}

\item{Klim}{the range for searching the root of level-3 sample size (\code{K}) numerically,
default is c(4, 10e10)}

\item{mlim}{the range for searching the root of budget (\code{m}) numerically,
default is the costs sampling \code{Klim} level-3 units across treatment conditions
or c(4 * Kcost, 10e10 * Kcost) with Kcost =
((1 - p) * (c1 * n * J + c2 * J + c3) + p * (c1t * n * J + c2t * J + c3t))}

\item{rounded}{logical; round the values of \code{p}, \code{n}/\code{J} that are
from functions \code{\link{od.3}}
to two decimal places and integer, respectively if TRUE,
no rounding if FALSE; default is TRUE.}
}
\value{
Required budget (and/or required level-3 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for three-level cluster randomized trials (CRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# unconstrained optimal design
myod1 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250)
myod1$out # output  # n = 7.9, J = 3.2, p = 0.28

# ------- power analyses by default considering costs and budget -------
# required budget and sample size
mym.1 <- power.3(expr = myod1, es = 0.3, q = 1, power = 0.8)
mym.1$out  # m = 7319, K = 44.4
mym.1$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
mym.1 <- power.3(es = 0.3, power = 0.8, q = 1,
                 icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
                 c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
                 n = 8, J = 3, p = 0.28)
# required budget and sample size with constrained p
mym.2 <- power.3(expr = myod1, es = 0.3, q = 1, power = 0.8,
                 constraint = list(p = 0.5))
mym.2$out  # m = 8843, K = 36.2
# required budget and sample size with constrained p and J
mym.3 <- power.3(expr = myod1, es = 0.3, q = 1, power = 0.8,
                 constraint = list(p = 0.5, J = 20))
mym.3$out  # m = 18775, K = 22.2

# Power calculation
mypower <- power.3(expr = myod1, q = 1, es = 0.3, m = 7319)
mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
mypower.1 <- power.3(expr = myod1, q = 1, es = 0.3, m = 7319,
                 constraint = list(p = 0.5))
mypower.1$out  # power = 0.72

# MDES calculation
mymdes <- power.3(expr = myod1, q = 1, power = 0.80, m = 7319)
mymdes$out  # MDES = 0.30


# ------- conventional power analyses with cost.model = FALSE-------
# Required sample size
myK <- power.3(cost.model = FALSE, expr = myod1, es = 0.3, q = 1, power = 0.8)
myK$out  # K = 44.4
myK$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
myK <- power.3(cost.model = FALSE, es = 0.3, power = 0.8, q = 1,
                  icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
                  n = 8, J = 3, p = 0.28)

# Power calculation
 mypower1 <- power.3(cost.model = FALSE, expr = myod1, K = 44, es = 0.3, q = 1)
 mypower1$out  # power = 0.80

# MDES calculation
mymdes1 <- power.3(cost.model = FALSE, expr = myod1, K = 44, power = 0.8, q = 1)
mymdes1$out  # es = 0.30


}
\references{
(1) Shen, Z., & Kelcey, B. (under review).
  Optimal sample allocation under unequal costs in cluster-randomized trials.
  Journal of Educational and Behavioral Statistics. (2) Shen, Z.(in progress).
  Using optimal sample allocation to
  improve design efficiency for multilevel randomized trials.
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
