% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teaching_helpers.R
\name{plot_sequence}
\alias{plot_sequence}
\title{Plot a number sequence}
\usage{
plot_sequence(
  definition = function(n) 1/n,
  start = 1,
  end = 100,
  limits = numeric()
)
}
\arguments{
\item{definition}{A \code{function} with a single argument \code{n} that computes the sequence
element \eqn{a_n}.}

\item{start}{An \code{integer}, the first sequence index.}

\item{end}{An \code{integer}, the last sequence index.}

\item{limits}{A \code{numeric} \code{vector} of limits to draw as horizontal lines.}
}
\value{
A \code{ggplot2} object.
}
\description{
This function plots a sequence of numbers.
}
\examples{
definition <- function(n) ifelse(n \%in\% factorial(1:10), 1, 1 / n)
plot_sequence(definition)

}
