% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_name.R
\name{variable_name}
\alias{variable_name}
\title{Determine variable name}
\usage{
variable_name(variable, fallback = "unnamed")
}
\arguments{
\item{variable}{[\code{any}]\cr
Any object.}

\item{fallback}{[\code{character(1)}]\cr
A fallback name if for some reason the actual variable name
(which must be a single \code{character}) cannot be determined.}
}
\value{
A \code{character}, the variable name.
}
\description{
This function tries to determine the name of a variable passed to a
\code{function}.
}
\examples{
variable_name(a)
f <- function(x) variable_name(x)
f(x = a)
}
\seealso{
Other function helpers: 
\code{\link{do.call_timed}()},
\code{\link{function_arguments}()},
\code{\link{function_body}()},
\code{\link{function_defaults}()},
\code{\link{quiet}()},
\code{\link{timed}()},
\code{\link{try_silent}()}
}
\concept{function helpers}
\keyword{functional}
