% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-regression.R
\name{ols_stepwise}
\alias{ols_stepwise}
\alias{ols_stepwise.default}
\alias{plot.ols_stepwise}
\title{Stepwise Regression}
\usage{
ols_stepwise(model, ...)

\method{ols_stepwise}{default}(model, pent = 0.1, prem = 0.3,
  details = FALSE, ...)

\method{plot}{ols_stepwise}(x, model = NA, ...)
}
\arguments{
\item{model}{an object of class \code{lm}; the model should include all candidate predictor variables}

\item{...}{other arguments}

\item{pent}{p value; variables with p value less than \code{pent} will enter into the model}

\item{prem}{p value; variables with p more than \code{prem} will be removed from the model}

\item{details}{logical; if \code{TRUE}, will print the regression result at each step}

\item{x}{an object of class \code{ols_stepwise}}
}
\value{
\code{ols_stepwise} returns an object of class \code{"ols_stepwise"}.
An object of class \code{"ols_stepwise"} is a list containing the
following components:

\item{orders}{candidate predictor variables according to the order by which they were added or removed from the model}
\item{method}{addition/deletion}
\item{steps}{total number of steps}
\item{predictors}{variables retained in the model (after addition)}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by entering and removing predictors based on 
p values, in a stepwise manner until there is no variable left to enter or remove any more.
}
\examples{
\dontrun{
# stepwise regression
model <- lm(y ~ ., data = surgical)
ols_stepwise(model)
}

\dontrun{
# stepwise regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_stepwise(model)
plot(k)
}

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
