context('stepwise regression output')

model <- lm(y ~ ., data = surgical)

test_that('output from stepwise regression is as expected', {

	x <- cat("Stepwise Selection Method                                                                  

Candidate Terms:                                                                           

1 . bcs                                                                                    
2 . pindex                                                                                 
3 . enzyme_test                                                                            
4 . liver_test                                                                             
5 . age                                                                                    
6 . gender                                                                                 
7 . alc_mod                                                                                
8 . alc_heavy                                                                              

------------------------------------------------------------------------------------------
                                Stepwise Selection Summary                                 
------------------------------------------------------------------------------------------
                        Added/                   Adj.                                         
Step     Variable      Removed     R-Square    R-Square     C(p)        AIC         RMSE      
------------------------------------------------------------------------------------------
   1    liver_test     addition       0.455       0.444    62.5120    771.8753    296.2992    
   2     alc_heavy     addition       0.567       0.550    41.3680    761.4394    266.6484    
   3    enzyme_test    addition       0.659       0.639    24.3380    750.5089    238.9145    
   4      pindex       addition       0.750       0.730     7.5370    735.7146    206.5835    
   5        bcs        addition       0.781       0.758     3.1920    730.6204    195.4544    
------------------------------------------------------------------------------------------")

	expect_equivalent(print(ols_stepwise(model)), x)

})

test_that('output from stepwise regression is as expected when details == TRUE', {

	x <- cat("Variable Selection Procedure
 Dependent Variable: y 

 Stepwise Selection: Step 1 

 Variable liver_test Entered 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.674       RMSE                 296.299 
R-Squared               0.455       Coef. Var             42.202 
Adj. R-Squared          0.444       MSE                87793.232 
Pred R-Squared          0.386       MAE                  212.857 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    3804272.477         1    3804272.477    43.332    0.0000 
Residual      4565248.060        52      87793.232                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                    Parameter Estimates                                     
-------------------------------------------------------------------------------------------
      model       Beta    Std. Error    Std. Beta      t       Sig        lower      upper 
-------------------------------------------------------------------------------------------
(Intercept)     15.191       111.869                 0.136    0.893    -209.290    239.671 
 liver_test    250.305        38.025        0.674    6.583    0.000     174.003    326.607 
-------------------------------------------------------------------------------------------


1 variable(s) added...
Stepwise Selection: Step 2 

 Variable alc_heavy Entered 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.753       RMSE                 266.648 
R-Squared               0.567       Coef. Var             37.979 
Adj. R-Squared          0.550       MSE                71101.387 
Pred R-Squared          0.487       MAE                  187.393 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    4743349.776         2    2371674.888    33.356    0.0000 
Residual      3626170.761        51      71101.387                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                    Parameter Estimates                                      
--------------------------------------------------------------------------------------------
      model       Beta    Std. Error    Std. Beta      t        Sig        lower      upper 
--------------------------------------------------------------------------------------------
(Intercept)     -5.069       100.828                 -0.050    0.960    -207.490    197.352 
 liver_test    234.597        34.491        0.632     6.802    0.000     165.353    303.841 
  alc_heavy    342.183        94.156        0.338     3.634    0.001     153.157    531.208 
--------------------------------------------------------------------------------------------


1 variable(s) added...
Stepwise Selection: Step 3 

 Variable enzyme_test Entered 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.812       RMSE                 238.914 
R-Squared               0.659       Coef. Var             34.029 
Adj. R-Squared          0.639       MSE                57080.128 
Pred R-Squared          0.567       MAE                  170.603 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    5515514.136         3    1838504.712    32.209    0.0000 
Residual      2854006.401        50      57080.128                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                     Parameter Estimates                                      
---------------------------------------------------------------------------------------------
      model        Beta    Std. Error    Std. Beta      t        Sig        lower      upper 
---------------------------------------------------------------------------------------------
(Intercept)    -344.559       129.156                 -2.668    0.010    -603.976    -85.141 
 liver_test     183.844        33.845        0.495     5.432    0.000     115.865    251.823 
  alc_heavy     319.662        84.585        0.315     3.779    0.000     149.769    489.555 
enzyme_test       6.263         1.703        0.335     3.678    0.001       2.843      9.683 
---------------------------------------------------------------------------------------------


1 variable(s) added...
Stepwise Selection: Step 4 

 Variable pindex Entered 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.866       RMSE                 206.584 
R-Squared               0.750       Coef. Var             29.424 
Adj. R-Squared          0.730       MSE                42676.744 
Pred R-Squared          0.669       MAE                  146.473 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    6278360.060         4    1569590.015    36.779    0.0000 
Residual      2091160.477        49      42676.744                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                      Parameter Estimates                                       
-----------------------------------------------------------------------------------------------
      model        Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
-----------------------------------------------------------------------------------------------
(Intercept)    -789.012       153.372                 -5.144    0.000    -1097.226    -480.799 
 liver_test     125.474        32.358        0.338     3.878    0.000       60.448     190.499 
  alc_heavy     359.875        73.754        0.355     4.879    0.000      211.660     508.089 
enzyme_test       7.548         1.503        0.404     5.020    0.000        4.527      10.569 
     pindex       7.876         1.863        0.335     4.228    0.000        4.133      11.620 
-----------------------------------------------------------------------------------------------


1 variable(s) added...
Stepwise Selection: Step 5 

 Variable bcs Entered 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.884       RMSE                 195.454 
R-Squared               0.781       Coef. Var             27.839 
Adj. R-Squared          0.758       MSE                38202.426 
Pred R-Squared          0.700       MAE                  137.656 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    6535804.090         5    1307160.818    34.217    0.0000 
Residual      1833716.447        48      38202.426                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                      Parameter Estimates                                        
------------------------------------------------------------------------------------------------
      model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
------------------------------------------------------------------------------------------------
(Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
 liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
  alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
     pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
        bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
------------------------------------------------------------------------------------------------


No more variables to be added or removed.
Stepwise Selection Method                                                                  

Candidate Terms:                                                                           

1 . bcs                                                                                    
2 . pindex                                                                                 
3 . enzyme_test                                                                            
4 . liver_test                                                                             
5 . age                                                                                    
6 . gender                                                                                 
7 . alc_mod                                                                                
8 . alc_heavy                                                                              

------------------------------------------------------------------------------------------
                                Stepwise Selection Summary                                 
------------------------------------------------------------------------------------------
                        Added/                   Adj.                                         
Step     Variable      Removed     R-Square    R-Square     C(p)        AIC         RMSE      
------------------------------------------------------------------------------------------
   1    liver_test     addition       0.455       0.444    62.5120    771.8753    296.2992    
   2     alc_heavy     addition       0.567       0.550    41.3680    761.4394    266.6484    
   3    enzyme_test    addition       0.659       0.639    24.3380    750.5089    238.9145    
   4      pindex       addition       0.750       0.730     7.5370    735.7146    206.5835    
   5        bcs        addition       0.781       0.758     3.1920    730.6204    195.4544    
------------------------------------------------------------------------------------------")


	expect_equivalent(print(ols_stepwise(model, details = TRUE)), x)

})