% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-backward-regression.R
\name{ols_step_backward_p}
\alias{ols_step_backward_p}
\alias{ols_step_backward_p.default}
\alias{plot.ols_step_backward_p}
\alias{ols_step_backward}
\title{Stepwise backward regression}
\usage{
ols_step_backward_p(model, ...)

\method{ols_step_backward_p}{default}(model, prem = 0.3, details = FALSE,
  ...)

\method{plot}{ols_step_backward_p}(x, model = NA, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other inputs.}

\item{prem}{p value; variables with p more than \code{prem} will be removed
from the model.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_backward_p}.}
}
\value{
\code{ols_step_backward_p} returns an object of class \code{"ols_step_backward_p"}.
An object of class \code{"ols_step_backward_p"} is a list containing the
following components:

\item{model}{final model; an object of class \code{lm}}
\item{steps}{total number of steps}
\item{removed}{variables removed from the model}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by
removing predictors based on p values, in a stepwise manner until there is
no variable left to remove any more.
}
\section{Deprecated Function}{

\code{ols_step_backward()} has been deprecated. Instead use \code{ols_step_backward_p()}.
}

\examples{
# stepwise backward regression
model <- lm(y ~ ., data = surgical)
ols_step_backward_p(model)

# stepwise backward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_backward_p(model)
plot(k)

# final model
k$model

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
\seealso{
Other variable selection procedures: \code{\link{ols_step_all_possible}},
  \code{\link{ols_step_backward_aic}},
  \code{\link{ols_step_best_subset}},
  \code{\link{ols_step_both_aic}},
  \code{\link{ols_step_forward_aic}},
  \code{\link{ols_step_forward_p}}
}
