% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-bartlett-test.R
\name{ols_test_bartlett}
\alias{ols_test_bartlett}
\alias{ols_test_bartlett.default}
\alias{ols_bartlett_test}
\title{Bartlett test}
\usage{
ols_test_bartlett(data, ...)

\method{ols_test_bartlett}{default}(data, ..., group_var = NULL)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{...}{Columns in \code{data}.}

\item{group_var}{Grouping variable.}
}
\value{
\code{ols_test_bartlett} returns an object of class \code{"ols_test_bartlett"}.
An object of class \code{"ols_test_bartlett"} is a list containing the
following components:

\item{fstat}{f statistic}
\item{pval}{p-value of \code{fstat}}
\item{df}{degrees of freedom}
}
\description{
Test if k samples are from populations with equal variances.
}
\details{
Bartlett's test is used to test if variances across samples is equal.
It is sensitive to departures from normality. The Levene test
is an alternative test that is less sensitive to departures from normality.
}
\section{Deprecated Function}{

\code{ols_bartlett_test()} has been deprecated. Instead use \code{ols_test_bartlett()}.
}

\examples{
# using grouping variable
library(descriptr)
ols_test_bartlett(mtcarz, mpg, group_var = cyl)

# using variables
ols_test_bartlett(hsb, read, write)

}
\references{
Snedecor, George W. and Cochran, William G. (1989), Statistical Methods,
Eighth Edition, Iowa State University Press.
}
\seealso{
Other heteroskedasticity tests: \code{\link{ols_test_breusch_pagan}},
  \code{\link{ols_test_f}}, \code{\link{ols_test_score}}
}
