% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctcisQTL.R
\name{ctcisQTL}
\alias{ctcisQTL}
\title{Cell-Type-Specific QTL analysis}
\usage{
ctcisQTL(
  X,
  Xpos,
  W,
  Y,
  Ypos,
  C = NULL,
  max.pos.diff = 1e+06,
  nPC = NULL,
  outdir = tempdir(),
  outfile = "ctcisQTL.out.txt",
  num.cores = 1,
  seed = 123
)
}
\arguments{
\item{X}{Matrix (or vector) of SNP genotypes; SNPs x samples.}

\item{Xpos}{Vector of the physical position of X}

\item{W}{Matrix of proportion of cell types; samples x cell types.}

\item{Y}{Matrix (or vector) of bulk omics measurements; markers x samples.}

\item{Ypos}{Vector of the physical position of Y}

\item{C}{Matrix (or vector) of covariates; samples x covariates.
X, Xpos, W, Y, Ypos, C should be numeric.}

\item{max.pos.diff}{Maximum positional difference to compute cis-QTL.
Association is computed between a row of X and a row of Y,
only when thet are within this limit.
Since the limiting is only by position, the function needs to be run
separately for each chromosome.}

\item{nPC}{A hyperparameter that (indirectly) specifies the penalty
for ridge regression.  If \code{NULL}, it is inferred from the data.
A unique hyperparameter is applied to all SNP-marker pairs.}

\item{outdir}{Output directory.}

\item{outfile}{Output file.}

\item{num.cores}{Number of CPU cores to use.
Full and marginal tests are run in serial, thus num.cores is ignored.}

\item{seed}{Seed for random number generation.}
}
\value{
The estimate, statistic, p.value are written to the specified file.
}
\description{
Cell-Type-Specific QTL analysis
}
\details{
The functionality is almost the same as the ridge test
in ctassoc.
Association is tested between each row of Y and each row of X.
Usually, the former will be a methylation/expression marker,
and the latter will be a SNP.
To cope with the large number of combinations,
the testing is limited to pairs whose position is within
the difference specified by \code{max.pos.diff}
In addition, a uniform hyperparameter of ridge regression is used
for all pairs.
We use the \link[ridge]{linearRidge} function of the ridge package.
}
\examples{
\donttest{
data(GSE79262small)
X    = GSE79262small$X
Xpos = GSE79262small$Xpos
W    = GSE79262small$W
Y    = GSE79262small$Y
Ypos = GSE79262small$Ypos
C    = GSE79262small$C
Y    = Y[seq(1, 601, 20), ] # for brevity
Ypos = Ypos[seq(1, 601, 20)]
ctcisQTL(X, Xpos, W, Y, Ypos, C = C)
}

}
\seealso{
ctRUV
}
