% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prefix.r
\name{prefix}
\alias{prefix}
\title{Add leading characters to a string}
\usage{
prefix(x, len, pad = "0")
}
\arguments{
\item{x}{Character or character vector to which to add a prefix.}

\item{len}{The total number of characters desired for each string. If a string is already this length or longer then nothing will be prefixed to that string.}

\item{pad}{Character. Symbol to prefix to each string.}
}
\value{
Character or character vector.
}
\description{
Add leading characters to a string. This function is useful for ensuring, say, files get sorted in a particular order. For example, on some operating systems a file name "file 1" would come first, then "file 10", then "file 11", "file 12", etc., then "file 2", "file 21", and so on. Using \code{prefix}, you can add one or more leading zeros so that file names are as "file 01", "file 02", "file 03", and so on... and they will sort that way.
}
\examples{
prefix(1:5, len=2)
prefix(1:5, len=5)
prefix(1:5, len=3, pad='!')
}
