% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandUnits.r
\name{expandUnits}
\alias{expandUnits}
\title{Convert unit abbreviations to proper unit names}
\usage{
expandUnits(x)
}
\arguments{
\item{x}{Character: Abbreviations to convert. Case is ignored.
\itemize{
\item \code{'m'} will be converted to \code{'meters'}
\item \code{'m2'} will be converted to \code{'meters2'}
\item \code{'km'} will be converted to \code{'kilometers'}
\item \code{'km2'} will be converted to \code{'kilometers2'}
\item \code{'mi'} will be converted to \code{'miles'}
\item \code{'mi2'} will be converted to \code{'miles2'}
\item \code{'ft'} will be converted to \code{'feet'}
\item \code{'ft2'} will be converted to \code{'feet2'}
\item \code{'yd'} will be converted to \code{'yards'}
\item \code{'yd2'} will be converted to \code{'yards2'}
\item \code{'ac'} will be converted to \code{'acres'}
\item \code{'ha'} will be converted to \code{'hectares'}
\item \code{'nmi'} will be converted to \code{'nautical miles'}
\item \code{'nmi2'} will be converted to \code{'nautical miles2'}
}}
}
\description{
This function converts abbreviations of length and area units (e.g., "m", "km", and "ha") to their proper names (e.g., "meters", "kilometers", "hectares"). Square areal units are specified using an appended "2", where appropriate (e.g., "m2" means "meters-squared" and will be converted to "meters2").
}
\examples{

expandUnits(c('m', 'm2', 'ac', 'nm2'))

}
\seealso{
\code{\link{convertUnits}}, \code{\link{conversionFactors}}
}
