% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ra_table.R
\name{ra_table}
\alias{ra_table}
\title{Creates a ratio table from the count_fold_changes function output.}
\usage{
ra_table(fc_data, variable)
}
\arguments{
\item{fc_data}{data frame output from the count_fold_changes function}

\item{variable}{metadata from count_fold_changes, i.e. "Class"}
}
\description{
Create a ratio table
}
\examples{
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:20,]}
t_test_df <- omu_summary(count_data = c57_nos2KO_mouse_countDF,
metadata = c57_nos2KO_mouse_metadata, numerator = "Strep", denominator = "Mock",
response_variable = "Metabolite", Factor = "Treatment",
log_transform = TRUE, p_adjust = "BH", test_type = "welch")

fold_change_counts <- count_fold_changes(count_data = t_test_df, "Class",
column = "Class", sig_threshold = 0.05, keep_unknowns = FALSE)

ra_table(fc_data = fold_change_counts, variable = "Class")
}
