% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_decision_rule.R
\name{simulate_decision_rule}
\alias{simulate_decision_rule}
\title{Simulate results under a custom decision rule}
\usage{
simulate_decision_rule(
  model,
  n_per_group,
  decision_rule,
  data = NULL,
  parameter_sample = NULL,
  seed = NULL,
  nsim = 1L
)
}
\arguments{
\item{model}{model to use for sampling}

\item{n_per_group}{group size}

\item{decision_rule}{a function with signature \code{rule(mdl, data, ...)}
returning a
data frame with results from a applying the decision rule to data set\code{data},
typically contains a column \code{group_id} and a one column per decision/result.}

\item{data}{a data frame with visit data to condition on}

\item{parameter_sample}{an optional parameter sample to reuse}

\item{seed}{optional fixed seed}

\item{nsim}{the number of resamples to draw from the predictive distribution}
}
\value{
A data frame with columns \code{iter} (the resample index) and any columns
returned by \code{decision_rule} applied to each of the \code{nsim} datasets sampled
from the predictive distribution.
}
\description{
\code{simulate_decision_rule()} simulates from the prior or posterior
predictive distribution of a model and applies a custom decision rule to each
simulated data set.
}
\details{
The sampling is implementing using \code{furrr::future_map()} and thus
supports parallel execution when specifying a \code{future::plan()}.
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
rule <- function(model, data) {
  tibble::tibble(decision = sample(c(0,1), 1))
}
simulate_decision_rule(mdl, 5, rule, nsim = 3)

}
