% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_haplotypes.R
\name{plot.onemap_progeny_haplotypes}
\alias{plot.onemap_progeny_haplotypes}
\title{Plots progeny haplotypes}
\usage{
\method{plot}{onemap_progeny_haplotypes}(
  x,
  col = NULL,
  position = "stack",
  show_markers = TRUE,
  main = "Genotypes",
  ncol = 4,
  ...
)
}
\arguments{
\item{x}{object of class onemap_progeny_haplotypes}

\item{col}{Color of parents' homologous.}

\item{position}{"split" or "stack"; if "split" (default) the alleles' are plotted separately. if "stack" the parents' alleles are plotted together.}

\item{show_markers}{logical; if  \code{TRUE}, the markers (default) are plotted.}

\item{main}{An overall title for the plot; default is \code{NULL}.}

\item{ncol}{number of columns of the facet_wrap}

\item{...}{currently ignored}
}
\value{
a ggplot graphic
}
\description{
Figure is generated with the haplotypes for each selected individual. As a representation, the recombination breakpoints are here considered 
to be in the mean point of the distance between two markers.  It is important to highlight that it did not reflects the exact breakpoint position, 
specially if the genetic map have low resolution.
}
\examples{
 \donttest{
data("onemap_example_out")
twopts <- rf_2pts(onemap_example_out)
lg1 <- make_seq(twopts, 1:5)
lg1.map <- map(lg1)
plot(progeny_haplotypes(lg1.map))
}

}
\author{
Getulio Caixeta Ferreira, \email{getulio.caifer@gmail.com}

Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
