% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_planning_areas.R
\name{get_planning_areas}
\alias{get_planning_areas}
\title{Get Planning Areas (All)}
\usage{
get_planning_areas(token, year = NULL, read = NULL)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{year}{Optional, check \href{https://docs.onemap.sg/#planning-area-polygons}{documentation} for valid options. Invalid requests will are ignored by the API.}

\item{read}{Optional, which package to use to read geojson object. For "sf" objects, specify \code{read = "sf"} and for "sp" objects use \code{read = "rgdal"}. Note that if used, any missing geojson objects will be dropped (this affects the "Others" planning area returned by the API).}
}
\value{
If the parameter \code{read} is not specified, the function returns a raw JSON object with planning names and geojson string vectors. \cr \cr
If \code{read = "sf"}, the function returns a single "sf" dataframe with 2 columns: "name" (name of planning area) and "geometry", which contains the simple features. \cr \cr
If \code{read = "rgdal"}, the function returns a SpatialPolygonsDataFrame of "sp" class. The names of each planning area is recorded in the "name" column of the dataframe. \cr \cr
If an error occurs, the function returns NULL and a warning message is printed.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#planning-area-polygons}{Planning Area Polygons API}. It returns the data either in raw format or a combined sf or sp object.
}
\note{
The \code{read = "rgdal"} option will take a longer time to return an output than the \code{read = "sf"} option. \cr \cr
If \code{read} is specified, any missing geojson objects will be dropped (this affects the "Others" planning area returned by the API). The returned outputs are NOT projected. \cr \cr
If the user specifies a \code{read} method but does not have the corresponding package installed, the function will return the raw JSON and print a warning message.
}
\examples{
# returns raw JSON object
\dontrun{get_planning_areas(token)}
\dontrun{get_planning_areas(token, 2008)}

# returns dataframe of class "sf"
\dontrun{get_planning_areas(token, read = "sf")}

# returns SpatialPolygonsDataFrame ("sp" object)
\dontrun{get_planning_areas(token, read = "rgdal")}

# error: output is NULL, warning message shows status code
\dontrun{get_planning_areas("invalid_token")}
}
