% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_planning_names.R
\name{get_planning_names}
\alias{get_planning_names}
\title{Get Planning Area Names}
\usage{
get_planning_names(token, year = NULL)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{year}{Optional, check \href{https://www.onemap.gov.sg/docs/#names-of-planning-area}{documentation} for valid options. Invalid requests will are ignored by the API.}
}
\value{
A tibble with 2 columns:
\describe{
  \item{id}{Planning area id}
  \item{pln_area_n}{Planning area name}
}
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/docs/#names-of-planning-area}{Names of Planning Area API}. It returns the data as a tibble.
}
\examples{
# returns tibble
\dontrun{get_planning_names(token)}
\dontrun{get_planning_names(token, 2008)}

# error: output is NULL, warning message shows status code
\dontrun{get_planning_names("invalid_token")}
}
