% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.env_summarized.R
\name{plot.env_summarized}
\alias{plot.env_summarized}
\title{plot.env_summarized}
\usage{
\method{plot}{env_summarized}(
  x,
  col = c("#97CBDE", "#E1B0B5"),
  x_lab = NULL,
  y_lab = NULL,
  base_size = 10,
  label = TRUE,
  ...
)
}
\arguments{
\item{x}{Random patterns.}

\item{col}{Colors for areas above and below envelope.}

\item{x_lab, y_lab}{Labels of x- and y-axis.}

\item{base_size}{Base size of plot}

\item{label}{If TRUE the ratios of the area above and below are added to the plot.}

\item{...}{To be generic for plotting function.}
}
\value{
ggplot
}
\description{
Plotting method for \code{env_summarized} object
}
\details{
Plotting method for summarized envelope created with \code{\link{summarize_envelope}}.

Returns a \code{ggplot} object.
}
\examples{
set.seed(42)
input_pattern <- spatstat.random::rThomas(kappa = 15, scale = 0.05, mu = 5)

cluster_env <- spatstat.core::envelope(input_pattern, fun = "pcf", nsim = 39,
funargs = list(divisor = "d", correction = "Ripley", stoyan = 0.25))

x <- summarize_envelope(cluster_env)
plot(x)

}
\seealso{
\code{\link{summarize_envelope}}
}
