% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{OWL_list_attributes}
\alias{OWL_is_a}
\alias{OWL_is_a_and_part_of}
\alias{OWL_list_attributes}
\alias{OWL_list_attributes_per_node}
\alias{OWL_part_of}
\title{Create lists of attributes per node in OWL file}
\usage{
OWL_list_attributes_per_node(xpath, attribute)

OWL_is_a(nodes)

OWL_part_of(nodes)

OWL_is_a_and_part_of(nodes)
}
\arguments{
\item{xpath}{XPath expression.}

\item{attribute}{Name of attribute to extract for selected nodes.}

\item{nodes}{\code{xml_nodeset} object where nodes correspond to ontological terms.}
}
\description{
\code{\link{OWL_is_a}}, \code{\link{OWL_part_of}} and \code{\link{OWL_is_a_and_part_of}} return lists of attributes for ontological terms represented as a \code{xml_nodeset} (see \code{xml2} package for more details on \code{xml_nodesets}). \code{\link{OWL_is_a}} returns the superclass/`is a' term IDs for each node in the given nodes, and is the default value of the \code{parents} argument in the \code{\link{get_OWL}} function. \code{\link{OWL_list_attributes_per_node}} returns a function for extracting lists of attributes of subnodes for each node in a \code{xml_nodeset}. It accepts an XPath expression for selecting the subnodes of each node in the returned function's \code{nodes} argument, and an attribute name argument for specifying which attribute should be extracted for each one. The returned function should be suitable for use as a parameter to the \code{\link{get_OWL}} function.
}
\seealso{
\code{\link{OWL_strings_from_nodes}}
}

