% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{get_adjacency_matrix}
\alias{get_adjacency_matrix}
\title{Get an adjacency matrix for a set of ontological terms}
\usage{
get_adjacency_matrix(ontology, terms)
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{terms}{Character vector of ontological terms}
}
\value{
A logical matrix representing the adjacency matrix of \code{terms} based on the directed acyclic graph of \code{ontology}. A \code{TRUE} entry means the term correspnding to the column is a parent of the row term in \code{ontology}.
}
\description{
Get an adjacency matrix for a set of ontological terms
}
\examples{
library(ontologyIndex)
data(hpo)
get_adjacency_matrix(hpo, c("HP:0000118", "HP:0001873", "HP:0011877"))
}
\seealso{
\code{\link{get_pseudo_adjacency_matrix}}
}

