% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_sim_p}
\alias{get_sim_p}
\title{Get similarity p-value}
\usage{
get_sim_p(sym_sim_mat, case_group, min_its = 1000, max_its = 1e+06,
  signif = 0.05, log_dismiss = -15)
}
\arguments{
\item{sym_sim_mat}{Symmetric numeric similarity matrix}

\item{case_group}{Character or integer vector of cases specifying rownames/indices of cases for which to calculate a similarity p-value.}

\item{min_its}{Minimum number of simulated group similarities to calculate}

\item{max_its}{Maximum number of simulated group similarities to calculate}

\item{signif}{Threshold p-value of statistical significance}

\item{log_dismiss}{Threshold of log probability, below which to trigger return of current estimated p-value}
}
\value{
Numeric p-value of similarity computed from null distribution (group similarity of all groups of same size as \code{case_group}
}
\description{
Get similarity p-value
}
\seealso{
\code{\link{get_stratified_sim_p}}
}

