% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{add_pseudodata}
\alias{add_pseudodata}
\title{Add pseudodata}
\usage{
add_pseudodata(Edge.groups, Pseudo.data, Path.data)
}
\arguments{
\item{Edge.groups}{list. A list with groups of edge IDs.}

\item{Pseudo.data}{numeric. A vector with values of pdeusodata.}

\item{Path.data}{numeric. A list of path data obtained from the 'make_data_NHPP_KDE_Markov_kernel' function.}
}
\value{
A list of path data with the pseudodata added.
}
\description{
Adds a vector of pseudodata to the path data obtained from the 'make_data_NHPP_KDE_Markov_kernel' function.
}
\examples{
data("hym_hm", "hym_tree")
# Get hamming data from the head characters.
hm <- hym_hm$head
# Make NHPP path data.
nhpp <- make_data_NHPP_KDE_Markov_kernel(hm, add.psd = FALSE)
# Add pseudo data to path data.
psd <- lapply(nhpp, function(x) -x[x < 100] )
edge_groups <- as.list(1:length(hym_tree$edge.length))
nhpp_psd <- add_pseudodata(Edge.groups = edge_groups, Pseudo.data = psd, Path.data = nhpp)
# Check NHPP path data plus pseudodata for an arbitrary branch.
nhpp_psd[[5]]

}
\author{
Sergei Tarasov
}
