% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{get_rough_state_cols}
\alias{get_rough_state_cols}
\title{Multiple character state colors}
\usage{
get_rough_state_cols(tree)
}
\arguments{
\item{tree}{simmap object.}
}
\value{
A character vector with colors associated with state names.
}
\description{
Get state colors for ploting stochastic character maps when there many states.
}
\examples{
data("hym_stm_amalg")
# Get one sample of stochastic map from head.
tree <- hym_stm_amalg$head[[5]]
# Plot one amalgamated stochastic map from head.
phytools::plotSimmap(tree, get_rough_state_cols(tree), 
lwd = 3, pts = FALSE,ftype = "off")

}
\author{
Sergei Tarasov
}
