% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.symbol.r
\name{opal.symbol_save}
\alias{opal.symbol_save}
\title{Save a tibble}
\usage{
opal.symbol_save(opal, symbol, destination)
}
\arguments{
\item{opal}{Opal object.}

\item{symbol}{Name of the R symbol representing a tibble.}

\item{destination}{The path of the file in the R session workspace. Supported file extensions are: 
.sav (SPSS), .zsav (compressed SPSS), .sas7bdat (SAS), .xpt (SAS Transport), .dta (Stata), 
.csv (comma separated values), .tsv (tab separated values).}
}
\description{
Save a tibble identified by symbol as a file of format SAS, SPSS, Stata, CSV or TSV in the remote R session working directory.
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.symbol_save(o, 'D', 'test.sav')
opal.logout(o)
}
}
\seealso{
Other symbol functions: \code{\link{opal.rm}},
  \code{\link{opal.symbol_import}},
  \code{\link{opal.symbol_rm}}, \code{\link{opal.symbols}}
}
\concept{symbol functions}
