% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.report.r
\name{opal.as_md_table}
\alias{opal.as_md_table}
\title{Array to Markdown}
\usage{
opal.as_md_table(
  table,
  icons = TRUE,
  digits = getOption("digits"),
  col.names = colnames(table),
  align,
  caption = NULL
)
}
\arguments{
\item{table}{An array, including a matrix or a data.frame.}

\item{icons}{Turn logicals to icons (requires bootstrap style). Default is TRUE.}

\item{digits}{The maximum number of digits for numeric columns (passed to round()); it can also be a vector of length ncol(table) to set the number of digits for individual columns.}

\item{col.names}{A character vector of column names to be used in the table}

\item{align}{The alignment of columns: a character vector consisting of 'l' (left), 'c' (center) and/or 'r' (right); by default, numeric columns are right-aligned, and other columns are left-aligned; if align = NULL, the default alignment is used.}

\item{caption}{The table caption.}
}
\description{
Helper function for turning an array into its Markdown representation.
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.as_md_table(opal.variables(o, 'datashield', 'CNSIM1'))
opal.logout(o)
}
}
