% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.r
\name{opal.project_perm_delete}
\alias{opal.project_perm_delete}
\title{Delete a permission from a project}
\usage{
opal.project_perm_delete(opal, project, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}
}
\description{
Delete a permission that was applied on a project. Silently returns when there is no such permission.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.project_perm_add(o, 'CNSIM', c('andrei', 'valentina'), 'user', 'administrate')
opal.project_perm(o, 'CNSIM')
opal.project_perm_delete(o, 'CNSIM', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
