% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.R
\name{opal.file_mv}
\alias{opal.file_mv}
\title{Move and/or rename a file}
\usage{
opal.file_mv(opal, source, destination)
}
\arguments{
\item{opal}{Opal object.}

\item{source}{Path to the file in the Opal file system.}

\item{destination}{New path to the file in the Opal file system.}
}
\description{
Move and/or rename a file or a folder in the Opal file system.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# move a file to another folder
opal.file_mv(o, '/home/administrator/export/some-data.csv', '/home/userx/deliverables')
# rename a file
opal.file_mv(o, '/home/administrator/export/some-data-20170123.csv', 
                '/home/administrator/export/some-data.csv')
# move and rename a file
opal.file_mv(o, '/home/administrator/export/some-data-20170123.csv', 
                '/home/userx/deliverables/some-data.csv')
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir_tmp}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()},
\code{\link{opal.file}()}
}
\concept{file functions}
