% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.activity}
\alias{dsadmin.activity}
\title{Get DataSHIELD activity}
\usage{
dsadmin.activity(
  opal,
  user = NULL,
  profile = NULL,
  from = NULL,
  to = NULL,
  df = TRUE
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{user}{Optional user name.}

\item{profile}{Optional profile name.}

\item{from}{Optional start date.}

\item{to}{Optional end date.}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the recorded DataSHIELD session metrics.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# all sessions metrics
dsadmin.activity(o)
# user and profile specific session metrics
dsadmin.activity(o, user = 'dsuser', profile = 'default')
# user sessions in a time range
dsadmin.activity(o, user = "dsuser", from = "2022-07-01", to = "2023-01-01")
opal.logout(o)
}
}
