% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_create}
\alias{opal.table_create}
\title{Create an Opal table or view}
\usage{
opal.table_create(opal, project, table, type = "Participant", tables = NULL)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{table}{Table name to be created}

\item{type}{Entity type, default is "Participant". Ignored if some table references are 
provided.}

\item{tables}{List of the fully qualified table names that are referred by the view.}
}
\description{
Create an Opal table if it does not already exist. If a list of table references are provided,
the table will be a view. The table/view created will have no dictionary, use 
\link{opal.table_dictionary_update} to apply a dictionary.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# make a raw table
opal.table_create(o, "CNSIM", "CNSIM4")
# make a view
opal.table_create(o, "CNSIM", "CNSIM123", 
                  tables = c("CNSIM.CNSIM1", "CNSIM.CNSIM2", "CNSIM.CNSIM3"))
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.perms}()},
\code{\link{opal.resource_view_create}()},
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()},
\code{\link{opal.table_view_update}()}
}
\concept{table functions}
