% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_import}
\alias{opal.table_import}
\title{Import a file as table}
\usage{
opal.table_import(
  opal,
  file,
  project,
  table,
  identifiers = NULL,
  policy = "required",
  id.name = "id",
  type = "Participant",
  wait = TRUE
)
}
\arguments{
\item{opal}{Opal object.}

\item{file}{Path in Opal to the file that will be read as a tibble.}

\item{project}{Name of the project into which the data are to be imported.}

\item{table}{Destination table name.}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to Opal.}

\item{policy}{Identifiers policy: 'required' (each identifiers must be mapped prior importation (default)), 'ignore' (ignore unknown identifiers) and 'generate' (generate a system identifier for each unknown identifier).}

\item{id.name}{The name of the column representing the entity identifiers. Default is 'id'.}

\item{type}{Entity type (what the data are about). Default is 'Participant'.}

\item{wait}{Wait for import task completion. Default is TRUE.}
}
\description{
Import a file as a table in Opal. The file formats supported are: RDS (.rds), SPSS (.sav), 
SPSS compressed (.zsav), SAS (.sas7bdat), SAS Transport (.xpt), Stata (.dta). 
The RDS format is a serialized single R object (expected to be of tibble class), that can be obtained using base::saveRDS().
The other file formats are the ones supported by the haven R package.
This operation creates an importation task in Opal that can be followed (see tasks related functions).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.table_import(o, '/home/administrator/mydataset.rds', 'test', 'mytable')
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.perms}()},
\code{\link{opal.resource_view_create}()},
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()},
\code{\link{opal.table_view_update}()}
}
\concept{table functions}
