% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opart_gaussian.R
\name{opart_gaussian}
\alias{opart_gaussian}
\title{compute the optimal changepoint model for a vector of real-valued data
and a non-negative real-valued penalty,
given the square loss (to minimize) / gaussian likelihood (to maximize)}
\usage{
opart_gaussian(data, penalty)
}
\arguments{
\item{data}{A numerical vector for which the changepoint model is to be computed}

\item{penalty}{A non-negative real number indicating penalty parameter}
}
\value{
A vector of the optimal cost values and a vector of the optimal segment ends
}
\description{
compute the optimal changepoint model for a vector of real-valued data
and a non-negative real-valued penalty,
given the square loss (to minimize) / gaussian likelihood (to maximize)
}
\examples{
data(neuroblastoma, package="neuroblastoma")
selectedData <- subset(neuroblastoma$profiles, profile.id=="1" & chromosome=="1")
opart::opart_gaussian(data=selectedData$logratio, penalty=1)
}
