/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.util.ReverseListIterator;

public abstract class DiscourseElement {
    private List extents = new ArrayList(1);
    private int id = -1;
    private MentionContext lastExtent;

    public DiscourseElement(MentionContext mention) {
        this.lastExtent = mention;
        this.extents.add(mention);
    }

    public Iterator getRecentMentions() {
        return new ReverseListIterator(this.extents);
    }

    public Iterator getMentions() {
        return this.extents.listIterator();
    }

    public int getNumMentions() {
        return this.extents.size();
    }

    public void addMention(MentionContext mention) {
        this.extents.add(mention);
        this.lastExtent = mention;
    }

    public MentionContext getLastExtent() {
        return this.lastExtent;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        Iterator ei = this.extents.iterator();
        MentionContext ex = (MentionContext)ei.next();
        StringBuffer de = new StringBuffer();
        de.append("[ ").append(ex.toText());
        while (ei.hasNext()) {
            ex = (MentionContext)ei.next();
            de.append(", ").append(ex.toText());
        }
        de.append(" ]");
        return de.toString();
    }
}

