/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class NGram {
    private int[] words;

    protected NGram(int[] words) {
        if (words.length > 32) {
            throw new IllegalArgumentException("Only n-grams of size 32 or smaller can be created: n-gram length = " + words.length);
        }
        this.words = words;
    }

    public int size() {
        return this.words.length;
    }

    protected int[] getWords() {
        return this.words;
    }

    public boolean equals(Object o) {
        NGram ngram = (NGram)o;
        int wn = this.words.length;
        if (wn == ngram.words.length) {
            for (int wi = 0; wi < wn; ++wi) {
                if (this.words[wi] == ngram.words[wi]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int numBitsRegular = 32 / this.words.length;
        int numExtra = 32 % this.words.length;
        int maskExtra = -1 >>> 32 - (numBitsRegular + 1);
        int maskRegular = -1 >>> 32 - numBitsRegular;
        int code = 0;
        int leftMostBit = 0;
        for (int wi = 0; wi < this.words.length; ++wi) {
            int numBits;
            int mask;
            if (wi < numExtra) {
                mask = maskExtra;
                numBits = numBitsRegular + 1;
            } else {
                mask = maskRegular;
                numBits = numBitsRegular;
            }
            int word = this.words[wi] & mask;
            code |= (word <<= 32 - (leftMostBit += numBits) - numBits);
        }
        return code;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        while (null != line) {
            String[] snums = line.split(" ");
            int[] nums = new int[snums.length];
            for (int ni = 0; ni < nums.length; ++ni) {
                nums[ni] = Integer.parseInt(snums[ni]);
            }
            NGram ngram = new NGram(nums);
            int code = ngram.hashCode();
            System.out.println("hashcode=" + code + " size=" + ngram.size());
            for (int sh = 31; sh >= 0; --sh) {
                System.out.print(code >> sh & 1);
            }
            System.out.println();
            line = in.readLine();
        }
    }
}

