/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class IsAResolver
extends MaxentResolver {
    Pattern predicativePattern;

    public IsAResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "/imodel", m, 20);
        this.showExclusions = false;
        this.predicativePattern = Pattern.compile("^(,|--)$");
    }

    public IsAResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "/imodel", m, 20, nrr);
        this.showExclusions = false;
        this.predicativePattern = Pattern.compile("^(,|--)$");
    }

    public boolean canResolve(MentionContext ec) {
        if (ec.getHeadTokenTag().startsWith("NN")) {
            return ec.getPreviousToken() != null && this.predicativePattern.matcher(((Object)ec.getPreviousToken()).toString()).matches();
        }
        return false;
    }

    protected boolean excluded(MentionContext ec, DiscourseEntity de) {
        MentionContext cec = de.getLastExtent();
        if (ec.getSentenceNumber() != cec.getSentenceNumber()) {
            return true;
        }
        if (cec.getIndexSpan().getEnd() == ec.getIndexSpan().getStart() - 2) {
            return false;
        }
        if (cec.getIndexSpan().getEnd() == ec.getIndexSpan().getEnd()) {
            return false;
        }
        return cec.getIndexSpan().getEnd() > ec.getIndexSpan().getEnd() + 2 || ec.getNextToken() == null || !((Object)ec.getNextToken()).toString().equals(",") && !((Object)ec.getNextToken()).toString().equals(".");
    }

    protected boolean outOfRange(MentionContext ec, DiscourseEntity de) {
        MentionContext cec = de.getLastExtent();
        return cec.getSentenceNumber() != ec.getSentenceNumber();
    }

    protected boolean defaultReferent(DiscourseEntity de) {
        return true;
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            MentionContext ant = entity.getLastExtent();
            List leftContexts = IsAResolver.getContextFeatures(ant);
            int cn = leftContexts.size();
            for (int ci = 0; ci < cn; ++ci) {
                features.add("l" + leftContexts.get(ci));
            }
            List rightContexts = IsAResolver.getContextFeatures(mention);
            int cn2 = rightContexts.size();
            for (int ci = 0; ci < cn2; ++ci) {
                features.add("r" + rightContexts.get(ci));
            }
            features.add("hts" + ant.getHeadTokenTag() + "," + mention.getHeadTokenTag());
        }
        return features;
    }
}

