/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import opennlp.tools.coref.DefaultLinker;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.LinkerMode;
import opennlp.tools.coref.mention.DefaultParse;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.PTBMentionFinder;
import opennlp.tools.lang.english.CorefParse;
import opennlp.tools.parser.Parse;

public class TreebankLinker
extends DefaultLinker {
    public TreebankLinker(String project, LinkerMode mode) throws IOException {
        super(project, mode);
    }

    public TreebankLinker(String project, LinkerMode mode, boolean useDiscourseModel) throws IOException {
        super(project, mode, useDiscourseModel);
    }

    public TreebankLinker(String project, LinkerMode mode, boolean useDiscourseModel, double fixedNonReferentialProbability) throws IOException {
        super(project, mode, useDiscourseModel, fixedNonReferentialProbability);
    }

    protected void initMentionFinder() {
        this.mentionFinder = PTBMentionFinder.getInstance(this.headFinder);
    }

    private static void showEntities(DiscourseEntity[] entities) {
        int en = entities.length;
        for (int ei = 0; ei < en; ++ei) {
            System.out.println(ei + " " + entities[ei]);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: TreebankLinker model_directory < parses");
            System.exit(1);
        }
        int ai = 0;
        String dataDir = args[ai++];
        BufferedReader in = ai == args.length ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(args[ai]));
        TreebankLinker treebankLinker = new TreebankLinker(dataDir, LinkerMode.TEST);
        int sentenceNumber = 0;
        ArrayList<Mention> document = new ArrayList<Mention>();
        ArrayList<Parse> parses = new ArrayList<Parse>();
        String line = in.readLine();
        while (null != line) {
            if (line.equals("")) {
                DiscourseEntity[] entities = treebankLinker.getEntities(document.toArray(new Mention[document.size()]));
                new CorefParse(parses, entities).show();
                sentenceNumber = 0;
                document.clear();
                parses.clear();
            } else {
                Parse p = Parse.parseParse(line);
                parses.add(p);
                Mention[] extents = treebankLinker.getMentionFinder().getMentions(new DefaultParse(p, sentenceNumber));
                int en = extents.length;
                for (int ei = 0; ei < en; ++ei) {
                    if (extents[ei].getParse() != null) continue;
                    Parse snp = new Parse(p.getText(), extents[ei].getSpan(), "NML", 1.0, 0);
                    p.insert(snp);
                    extents[ei].setParse(new DefaultParse(snp, sentenceNumber));
                }
                document.addAll(Arrays.asList(extents));
                ++sentenceNumber;
            }
            line = in.readLine();
        }
        if (document.size() > 0) {
            DiscourseEntity[] entities = treebankLinker.getEntities(document.toArray(new Mention[document.size()]));
            new CorefParse(parses, entities).show();
        }
    }
}

